IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_IMP_LIBERACAO_ALCADA]') 
					AND type in (N'U')) 
begin


CREATE TABLE [dbo].[EST_PROD_IMP_LIBERACAO_ALCADA](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_IMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD_LIBERACAO] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_PROD_IMP_LIBERACAO_ALCADA] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_IMP] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_PROD_IMP_LIBERACAO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_LIBERACAO_ALCADA_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_IMP_LIBERACAO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_LIBERACAO_ALCADA_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PROD_IMP_LIBERACAO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_LIBERACAO_ALCADA_CD_IMP]  DEFAULT ((0)) FOR [CD_IMP]

ALTER TABLE [dbo].[EST_PROD_IMP_LIBERACAO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_LIBERACAO_ALCADA_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_IMP_LIBERACAO_ALCADA] ADD  CONSTRAINT [DF_EST_PROD_IMP_LIBERACAO_ALCADA_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_PROD_IMP_LIBERACAO_ALCADA]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_IMP_LIBERACAO_ALCADA_EST_PROD_IMP] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_IMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD_IMP] ([CD_EMP], [CD_FILIAL], [CD_IMP], [CD_PROD])

ALTER TABLE [dbo].[EST_PROD_IMP_LIBERACAO_ALCADA] CHECK CONSTRAINT [FK_EST_PROD_IMP_LIBERACAO_ALCADA_EST_PROD_IMP]
end